﻿<?php
include_once './includes/config.inc.php';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<title>Super Store Finder - Features</title>
	<?php include ROOT."themes/meta_others.php"; ?>
</head>
<body id="features">
	<div id="wrapper">
		<div id="header">
			
			<?php include ROOT."themes/nav.inc.php"; ?>
		</div>

		<div id="main">
			<h2>Features</h2>
			
			<div class="user-html"><h3 id="item-description__super-store-finder-easy-to-use-google-maps-api-store-finder"><strong>Super Store Finder</strong> – Easy to use Google Maps API Store Finder</h3>
<strong>Super Store Finder</strong> is a multi-language fully featured PHP/Javascript/MySQL integrated with Google Maps API v3 that allows customers to locate your stores easily. Packed with Geo Location, Google Street View and Google Maps Direction your customers will never be lost again getting to your locations. The store finder will be able to list of nearby stores / outlets around your web visitors from nearest to the furthest distance away. 
<br><br>
Setup is really easy and quick (Refer <a href="http://superstorefinder.net/products/superstorefinder/docs">installation guide document here</a> or a <a href="https://www.youtube.com/watch?v=ut54uUZp63M">video guide here</a>) and support is always reliable and fantastic. Deploying the store finder to any website gets even easier when you can embed it to any web page and CMS or E-commerce sites (Joomla!, Wordpress, Drupal, Squarespace, Magento, Open Cart, etc. – Store Locator) by using the embed code (<a href="https://www.youtube.com/watch?v=HXQ4A7ZCMmo&amp;x-yt-ts=1422579428&amp;x-yt-cl=85114404#t=209">Embed video guide</a>). In addition, the Responsive version of Store Finder is also included and the user interface looks great on various platform such as PC, laptops, smart phones and other mobile devices.
<br><br>
<a href="http://superstorefinder.net/products/superstorefinder"><img src="http://superstorefinder.net/img/store.jpg" alt="Super Store Finder Demo"></a> <a href="http://superstorefinder.net/products/superstorefinder/admin"><img src="http://superstorefinder.net/img/admin.jpg" alt="Super Store Finder Admin Demo"></a> <a href="http://superstorefinder.net/products/superstorefinder/index_geoip.php"><img src="http://superstorefinder.net/img/geoip.jpg" alt="Super Store Finder with Geo IP"></a> <a href="http://superstorefinder.net/clients/responsive"><img src="http://superstorefinder.net/img/responsive.jpg" alt="Super Store Finder Responsive Demo"></a>

<h3 id="item-description__main-features">Main Features</h3>

<ul>
<li>Fully integrated with <strong>Google API V3</strong>, this means no key is required.</li>
<li>Features <strong>Geo IP</strong> that detects your users access location and list nearby stores around them</li>
<li>User friendly interface design and powered by <strong>Bootstrap</strong>, which means you can use bootstrap components/scripts such as modal popup, tabs, alerts, tooltip, etc</li>
<li>Distance is sorted from nearest to furthest stores around the searched area</li>
<li>Public users can <strong>request to add store</strong> which will require admin approval</li>
<li>Customizable Map Markers</li>
<li>Super fast search response that doesn’t require page refresh</li>
<li>Search store based on <strong>categories with customizable icons</strong></li>
<li>Bouncing Animated Markers upon choosing a store for highlight purposes</li>
<li>Display store thumbnail if available</li>
<li>Customers can contact the stores directly</li>
<li><strong>Autofill feature</strong> on search field</li>
<li>View and get to the location personally with <strong>Google Street View</strong></li>
<li>Never lost your way again with <strong>Google Maps Direction</strong></li>
<li><strong>Bulk import</strong> of addresses using <strong>CSV</strong> (The script will perform geocode during import. For instructions, please refer to the <a href="http://www.youtube.com/watch?v=R784bmcW0hw">video guide</a> here)</li>
<li>Documented source code and completely easy to understand <a href="http://superstorefinder.net/products/superstorefinder/docs">Documentation &amp; User Guide</a></li>
<li><strong>Responsive Version</strong> that works on iPhone, iPads and other mobile devices</li>
<li>Tested and works on <strong>all major browsers</strong></li>
<li>Supports <strong>Unicode characters</strong></li>
<li>Supports <strong>multi-language</strong> with translation files ready (Up to 9 available pre-translated languages)</li>
<li><strong>Embed your store finder</strong> anywhere on any website by pasting the embed code.</li>
</ul>

<h3 id="item-description__administrator-s-features">Administrator’s Features</h3>

<ul>
<li>Secured <strong>Login Area</strong> for administrators</li>
<li>User friendly interface design and powered by <strong>Bootstrap</strong></li>
<li>Add and <strong>manage your stores</strong> easily</li>
<li><strong>Upload image</strong> for each store with auto generated thumbnail</li>
<li>Add and <strong>manage your category</strong></li>
<li><strong>Upload icon</strong> for each category with auto generated thumbnail</li>
<li>Auto-detect <strong>Longitude and Latitude</strong> upon entering address</li>
<li>Utilize <strong>jQuery and JSON</strong> to submit form and load map without having to refresh page</li>
<li>Easy to setup, extend and customize</li>
<li>Works on all major browsers</li>
<li>Supports <strong>multiple admin users</strong></li>
</ul>

<h3 id="item-description__features-highlight">Features Highlight</h3>

	<p><strong>Powerful Store Finder</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/powerfulstorefinder.jpg"></p>


	<p>The frontend of the store finder is designed and built to suit any of your business needs whether for searching business outlets, restaurants, cafes, hotels, exhibitions and other point of interests.</p>


	<p><strong>Secure Store Administrator’s Area</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/secureadmin.jpg"></p>


	<p>The secure backend lets you manage your stores and let your customers find them. The administrator’s area supports multiple admin users which can manage the store finder for you.</p>


	<p><strong>Show Customers Your Nearby Outlets</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/geoip.jpg"></p>


	<p>With Geo Location, wherever location your customers browse your store finder, it will detect nearby stores and display them sorted by nearest to furthest distance. This way, customers can get to your physical without any hassle.</p>


	<p><strong>Google Maps Direction</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/direction.jpg"></p>


	<p>Never get lost again with Google Map directions which will detect and display the nearest route available for your customers to get to your stores.</p>


	<p><strong>Street View Enabled</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/streetview.jpg"></p>


	<p>Zoom, pan and navigate through the panoramic view of your favorite locations world-wide</p>


	<p><strong>Embed Your Store Finder to any Website</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/embed.jpg"></p>


	<p>Whether you own a static website, Wordpress, Joomla, Drupal or others, you can copy and paste the embed code to publish your store finder immediately without any hassle.</p>


	<p><strong>Responsive Store Finder</strong></p>


	<p><img src="http://superstorefinder.net/products/superstorefinder/featuredimages/responsive.jpg"></p>


	<p>Super Store Finder is now fully responsive and available upon purchase. The user interface supports various devices including PC, Laptops, iPhone, iPad, Android Phones and other mobile devices. Check out the <a href="http://superstorefinder.net/clients/responsive">responsive demo</a> here or scan the QR code below on your mobile device.</p>


	<p><img src="http://superstorefinder.net/img/qr_responsive.png" alt="Responsive Super Store Finder demo qr code"></p>


	<p><strong>Fast and Reliable Support</strong></p>


	<p>We provide fast and reliable support to our customers, whether its an inquiry, troubleshooting, customization and special requests. If you need help with installation, just shoot us an email and we’ll do it for you for free. Send us an email <a href="http://codecanyon.net/user/highwarden">here</a>.</p>


	<p>Follow us on envato for new releases and products <a href="http://activeden.net/user/highwarden/follow">here</a></p>


<h3 id="item-description__what-are-buyers-saying">What are buyers saying</h3>
<p>“I really enjoyed working with this script. Your instructions are very clear and for someone who is new to PHP, it was a great learning experience. By the way, the embed feature was genius! That was great!” <br>—computernerdschris </p>
<p>“First, I would like to say…Great Job! One of the better store locator systems I have come across.” <br>—gruberdesigns </p>
<p>“I just bought this and started using it on my site within minutes. I am not a programmer and this was still very easy!” <br>—amymariejones33 </p>
<p>“Just purchased the Super Store Finder and it’s fantastic, exactly what my client needed and just the right level of customisation, so thank you for your efforts! Great value script.” <br>—Anna Trundle</p>

<p>“This is the best store finder script on codecanyon! Keep up with a great job!” <br>—Pinki</p>
You can find more reviews from real buyers in <a href="http://codecanyon.net/item/super-store-finder/discussion/3630922">comments page</a>.

<h3 id="item-description__real-world-usage">Real world usage</h3>
<ul>
<li><a href="http://hamptoncreek.com/justfindit/">http://hamptoncreek.com/justfindit/</a></li>
<li><a href="http://philipszoom.co.nz/store.php">http://philipszoom.co.nz/store.php</a></li>
<li><a href="http://blktown.com/Local">http://blktown.com/Local</a></li>
<li><a href="http://globidyne.com/coupon/">http://globidyne.com/coupon/</a></li>
<li><a href="http://group1201.com/test/AIM/hiring-areas.php">http://group1201.com/test/AIM/hiring-areas.php</a></li>
<li><a href="http://www.clear-coat.com/where-to-buy">http://www.clear-coat.com/where-to-buy</a></li>
<li><a href="http://wonderwinkscrubs.com/stores/search">http://wonderwinkscrubs.com/stores/search</a></li>
<li><a href="http://boulangerieauger.com/ou-trouver-nos-produits.html">http://boulangerieauger.com/ou-trouver-nos-produits.html</a></li>
<li><a href="http://www.find-a-stove-installer.co.uk/installer-search.html">http://www.find-a-stove-installer.co.uk/installer-search.html</a></li>
<li><a href="http://city-points.nl/store-locator/">http://city-points.nl/store-locator/</a></li>
<li><a href="http://www.rejuvenateinfo.com/store-locator/">http://www.rejuvenateinfo.com/store-locator/</a></li>
<li><a href="http://www.rentitsocial.com/">http://www.rentitsocial.com/</a></li>
<li><a href="http://checkoutmybuddy.com/consultantslocator.php">http://checkoutmybuddy.com/consultantslocator.php</a></li>
<li><a href="http://www.indallas.com/doctors-in-dallas/">http://www.indallas.com/doctors-in-dallas/</a></li>
<li><a href="http://www.sinsationalsmile.com/locations-contact.html">http://www.sinsationalsmile.com/locations-contact.html</a></li>
<li><a href="http://www.unionofangels.com/where-to-buy/">http://www.unionofangels.com/where-to-buy/</a></li>
<li><a href="http://www.strawberrybay.co.uk/stockists">http://www.strawberrybay.co.uk/stockists</a></li>
<li><a href="http://www.advancednaturals.com/physician-locator/">http://www.advancednaturals.com/physician-locator/</a></li>
<li><a href="http://ecrustyle.shark-server.com/superstorefinder/">http://ecrustyle.shark-server.com/superstorefinder/</a></li>
<li><a href="http://itsa10haircare.com/where-to-buy/">http://itsa10haircare.com/where-to-buy/</a></li>
<li><a href="http://indo.me/">http://indo.me/</a></li>
<li><a href="http://markleatherphysiotherapy.com/clinics.html">http://markleatherphysiotherapy.com/clinics.html</a></li>
</ul>
<p><i>Please note that all store finder designs are copyrighted by their authors.</i></p>

<p>If you wish (or don’t wish) your site to be listed here, please send me a <a href="http://codecanyon.net/user/highwarden">message</a>.</p>

<h3 id="item-description__changelog-updates">Changelog / Updates</h3>

	<p><strong>2.3</strong>  version 2.3 (Last Update 3rd Feb 2015)
</p><ul>
<li>Fixed miles and km issue during finding stores</li>
<li>Fixed radius issue in responsive version</li>
<li>Added default distance unit at installation page</li>
</ul>


	<p><strong>2.2</strong>  version 2.2 (Last Update 31st Jan 2015)
</p><ul>
<li>Fixed scrolling list issue that scrolls the entire page</li>
<li>Added scroll easing effect</li>
<li>Enhanced Request Add Store page for the responsive version</li>
<li>Enhanced embed feature for responsive and Compact themes</li>
</ul>


	<p><strong>2.1</strong>  (Last updated: 29 Jan 2015)
</p><ul>
<li>Added 2 steps Installation Tool for Super Store Finder</li>
</ul>


	<p><strong>2.0</strong>  (Last updated: 2 Jan 2015)
</p><ul>
<li>Added Geo IP functionality that able to detect visitor City and Country.</li>
<li>Fixed drag and drop longitude detection at Add / Edit Store page due to Google Maps Update</li>
</ul>


	<p><strong>1.9</strong>  (Last updated: 4 Sept 2014)
</p><ul>
<li>Drag and Drop Marker is now available at request add store, add new store and edit store page.</li>
</ul>
<strong>1.9.1</strong>  (Last updated: 18 Nov 2014)
<ul>
<li>Maps at store finder, add store, request add store and edit stop not displaying due to Geo IP public javascript provided by maxmind no longer working as they start charging. Patch has been added to fix the issue, for more info visit the FAQ page <a href="http://codecanyon.net/item/super-store-finder/3630922/faqs/22312">http://codecanyon.net/item/super-store-finder/3630922/faqs/22312</a></li>
</ul>


	<p><strong>1.8</strong>  (Last updated: 15 Aug 2014)
</p><ul>
<li>Added import and geo code stores from csv list at admin area</li>
<li>Added backup export stores at admin area</li>
<li>Added restore stores feature at admin area</li>
<li>Video for Import/Geocode CSV List, Backup and Restore <a href="http://www.youtube.com/watch?v=R784bmcW0hw">available here</a>.</li>
</ul>
<strong>1.8.1</strong>  (Last updated: 24 Aug 2014)
<ul>
<li>Added append options for CSV import &amp; geocode</li>
</ul>


	<p><strong>1.7</strong>  (Last updated: 13 Aug 2014)
</p><ul>
<li>Fixed result scroll to view upon clicking marker</li>
<li>Fixed bouncing markers issue</li>
<li>Replace obsolete mktime function at admin login page</li>
<li>Fixed pagination in category page</li>
<li>Fixed pagination in admin user list page</li>
</ul>


	<p><strong>1.6</strong>  (Last updated: 25 Mar 2014)
</p><ul>
<li>Fixed distance radius more than 1000 miles/km</li>
</ul>
<strong>1.6.1</strong>  (Last updated: 11 April 2014)
<ul>
<li>Fixed distance bug in Firefox non EN language settings</li>
</ul>


	<p><strong>1.5</strong>  (Last updated: 28 Jan 2013)
</p><ul>
<li>Updated to jQuery 1.9</li>
<li>Responsive version is now available for download</li>
<li>Fixed pagination bug in admin</li>
<li>Fixed misc javascript and bootstrap conflict error</li>
</ul>
<strong>1.5.1</strong>  (Last updated: 28 Jan 2013)
<ul>
<li>Improve the layout of responsive version</li>
</ul>
<strong>1.5.2</strong>  (Last updated: 30 Jan 2013)
<ul>
<li>Added responsive embed code for templates with dynamic sizes</li>
</ul>
<strong>1.5.3</strong>  (Last updated: 16 Mar 2013)
<ul>
<li>Fixed transparency for png category icon</li>
<li>Add store search filter in administrator’s area</li>
</ul>


	<p><strong>1.5.4</strong>  (Last updated: 27 Mar 2013)
</p><ul>
<li>Fixed address list inconsistency in Firefox and Chrome browser</li>
</ul>


	<p><strong>1.5.5</strong>  (Last updated: 14 Mar 2014)
</p><ul>
<li>Fixed text encoding issues</li>
<li>Fixed embed code in responsive version</li>
<li>Fixed front end CSS for responsive version</li>
</ul>


	<p><strong>1.5.6</strong>  (Last updated: 15 Mar 2014)
</p><ul>
<li>Fixed distance sorting issue (solution in FAQ <a href="http://codecanyon.net/item/super-store-finder/3630922/faqs/19775">here</a>)</li>
</ul>


	<p><strong>1.5.7</strong>  (Last updated: 17 Mar 2014)
</p><ul>
<li>-Multi-language for no nearby stores notification fix</li>
</ul>


	<p><strong>1.4</strong>  (Last updated: 28 Dec 2012)
</p><ul>
<li>Google Maps Direction feature is now live and available for download</li>
</ul>


	<p><strong>1.3</strong>  (Last updated: 27 Dec 2012)
</p><ul>
<li>Added Street view link at info window</li>
<li>Added Zoom here link at info window</li>
<li>Searching store by category is now available</li>
<li>Upload and customize category icons</li>
</ul>


	<p><strong>1.2</strong>  (Last updated: 18 Dec 2012)
</p><ul>
<li>Supports multi-language with 8 language file translations included</li>
<li>Users are able to set default language from config file (config.inc.php)</li>
<li><a href="http://superstorefinder.net/products/superstorefinder/language.php">Languages Pack</a> download page is now available (Email me if you would like to contribute your translation; refer <a href="http://codecanyon.net/item/super-store-finder/3630922/faqs">FAQ</a> for guide)</li>
<li>Fixed Store Finder misc CSS issues</li>
<li>Email notification is now in various languages</li>
<li>Description will now be shown at front end unless blank</li>
</ul>
<strong>1.2.1</strong>  (Last updated: 18 Dec 2012)
<ul>
<li>Super Store Finder Import Tool using CSV is now available</li>
<li>Added pagination to store list at backend</li>
<li>Added pagination to user admin list at backend</li>
<li>Added Arabic language</li>
</ul>


	<p><strong>1.2.2</strong>  (Last updated: 20 Dec 2012)
</p><ul>
<li>Fixed pagination showing extra empty page</li>
</ul>


	<p><strong>1.2.3</strong>  (Last updated: 21 Dec 2012)
</p><ul>
<li>Fixed floating map covering form in add / edit store page in admin area</li>
</ul>


	<p><strong>1.1</strong>  (Last updated: 16 Dec 2012)
</p><ul>
<li>Fixed misc Javascript and CSS Issues</li>
</ul></div>

</div>
		</div>
	</div>
<?php include ROOT."themes/footer.inc.php"; ?>
</body>
</html>